

#IFDEF __STORY_DEBUG__
	Print _constEngine_ & " " & _constBuild_ & " / Page / Allocation / Page"
	Flip : WaitKey ( )
#ENDIF

Declare Function Seq_To_DB_Direct ( Page_DB ( Any ) As SEQ_Database, PIndex As Long = 0 ) As Story_Page_Type

Declare Function Allocate_Page_Header ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Page_Entities ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Page_Options ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Page_Desc ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Entity_Direct ( Page As Story_Page_Type, EIndex As Long = 0, Buffer As String = "" ) As String

Declare Function Allocate_Options_Direct ( Page As Story_Page_Type, OIndex As Long = 0, Buffer As String = "" ) As String

Declare Function Allocate_Desc_Direct ( Page As Story_Page_Type, DIndex As Long = 0, Buffer As String = "" ) As String

Declare Function Allocate_Header_Direct ( Page As Story_Page_Type, Buffer As String = "" ) As String

Function Seq_To_DB_Direct ( Page_DB ( Any ) As SEQ_Database, PIndex As Long = 0 ) As Story_Page_Type

	Dim As String CI : CI = ""

	Dim As Story_Page_Type Page
	
	Dim As String PreBuffer, Queue_Buffer, Subject_Buffer

	'With Page

		Page .Index = PIndex
		
		Page .Filename = Str_Replace ( "/", "\", Gamepack .Root & Gamepack .Pack & "\Assets\Page\" & PageIndex ( Page .Index, 3 ) & ".seq" )
		
		If Is_File ( Page .Filename ) = 0 Then
			Return Page
		End If
		
		SimpleWait ( "Seq To DB Direct:" & SP & "(" & SP & "Page No." & Page .Index & SP & ")" & SP & QUOT & Page .Filename & QUOT, RGBA( 0, 255, 255, 255 ) )

		Page .Buffer = __Direct_Buffer ( Page .Filename ) 

		CI = SimpleWait ( "Buffer:" & CRLF & Page .Buffer, RGBA ( 64, 255, 196, 255 ) )

		__Set ( Page_DB ( ), PIndex, "Index", Page .Index )		
		__Set ( Page_DB ( ), PIndex, "Filename", Page .Filename )
		
		Subject_Buffer = ""
		Queue_Buffer = Page .Buffer
		
		Queue_Buffer = Allocate_Page_Header ( Page_DB ( ), Page, Queue_Buffer )

		Queue_Buffer = Allocate_Page_Entities ( Page_DB ( ), Page, Queue_Buffer )

		Queue_Buffer = Allocate_Page_Options ( Page_DB ( ), Page, Queue_Buffer )

		Queue_Buffer = Allocate_Page_Desc ( Page_DB ( ), Page, Queue_Buffer )
	
	'End With
	
	Return Page
	
End Function


Function Allocate_Page_Header ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String
	
	SimpleWait ( "Allocate_Page_Header" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page .Index & CRLF & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )
	
	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer
		
	With Page
					
		Dim As Long PIndex = .Index
		
		Queue_Buffer = Allocate_Header_Direct ( Page, Queue_Buffer )
		
		__Set ( Page_DB ( ), PIndex, "Caption", .Caption )
		__Set ( Page_DB ( ), PIndex, "A", .A )
		__Set ( Page_DB ( ), PIndex, "B", .B )
		__Set ( Page_DB ( ), PIndex, "Sprite", .Sprite )
	
	End With
		
	Return Queue_Buffer
	
End Function

Function Allocate_Page_Entities ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

	SimpleWait ( "Allocate_Page_Entities" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page .Index & CRLF & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )

	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer
	
	'With Page
		
		Dim As Long PIndex = Page .Index

		__Set ( Page_DB ( ), PIndex, "Caption", Page .Caption )
		__Set ( Page_DB ( ), PIndex, "A", Page .A )
		__Set ( Page_DB ( ), PIndex, "B", Page .B )
		__Set ( Page_DB ( ), PIndex, "Sprite", Page .Sprite )
	
		If Page .A = 0 Then
			SimpleWait ( "Erase" & SP & ".Entity", RGBA ( 255, 160, 64, 255 ) )
			Erase Page .Entity
		Else
			SimpleWait ( "ReDim Preserve" & SP & ".Entity" & SP & "(" & SP & "1" & SP & "To" & SP & Page .A & SP & ")", RGBA ( 255, 160, 64, 255 ) )
			ReDim Preserve Page .Entity ( 1 To Page .A )
		End If
		
		SimpleWait ( ".Entity" & SP & "(" & SP & LBound( Page .Entity, 1 ) & SP & "To" & SP & UBound( Page .Entity, 1 ) & SP & ")", RGBA ( 255, 160, 64, 255 ) )
		
		/' [ ! ] hangs on the below line '/
		'__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & "LBound", LBound( ( Page .Entity ), 1 ) )
		'__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & "UBound", UBound( ( Page .Entity ) , 1 ) )
				
		For EIndex As Long = 1 To UBound ( Page .Entity, 1 ) Step 1
			
			SimpleWait ( "For " & EIndex & " As Long = 1 To " & UBound ( Page .Entity, 1 ) & " Step 1", RGBA ( 255, 160, 64, 255 ) )
			
			Queue_Buffer = Allocate_Entity_Direct ( Page, EIndex, Queue_Buffer )

			'With Page .Entity ( EIndex )

				'__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Active", Page .Entity ( EIndex ).Active )
				'__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Raw", Page .Entity ( EIndex ).Raw )
				'__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Element", Page .Entity ( EIndex ).Element )
				'__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Count", Page .Entity ( EIndex ).Count )
				'__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Mode", Page .Entity ( EIndex ).Mode )
				'__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "ID", Page .Entity ( EIndex ).ID )
				
				'Page .Entity ( EIndex ).Sprite = ImageDestroy2 ( Page .Entity ( EIndex ).Sprite )
				'Page .Entity ( EIndex ).Scaled = ImageDestroy2 ( Page .Entity ( EIndex ).Scaled )

				'__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Sprite", Page .Entity ( EIndex ).Sprite )
				'__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Scaled", Page .Entity ( EIndex ).Scaled )
							
			'End With
			
		Next EIndex
		
	'End With

	Return Queue_Buffer
	
End Function

Function Allocate_Page_Options ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

	SimpleWait ( "Allocate_Page_Options" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page .Index & CRLF & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )

	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer

	With Page

		Dim As Long PIndex = .Index

		ReDim .Options ( 1 To 4 )		

		__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & "LBound", 1 )
		__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & "UBound", UBound( .Options, 1 ) )

		For OIndex As Long = 1 To UBound ( .Options, 1 ) Step 1
			
			SimpleWait ( "For " & OIndex & " As Long = 1 To " & UBound ( .Options, 1 ) & " Step 1", RGBA ( 255, 160, 64, 255 ) )
			
			Queue_Buffer = Allocate_Options_Direct ( Page, OIndex, Queue_Buffer )

			With .Options ( OIndex )

				__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & OIndex & VARSEP & "Key", .Key )
				__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & OIndex & VARSEP & "Dest", .Dest )
				__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & OIndex & VARSEP & "Req", .Req )
				__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & OIndex & VARSEP & "Caption", .Caption )
				__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & OIndex & VARSEP & "Active", .Active )
			
			End With

		Next OIndex
	
	End With
	
	Return Queue_Buffer
	
End Function

Function Allocate_Page_Desc ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

	SimpleWait ( "Allocate_Page_Desc" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page .Index & CRLF & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )

	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer

	With Page

		Dim As Long PIndex = .Index

		ReDim .Desc ( 1 To 4 )		

		__Set ( Page_DB ( ), PIndex, "Desc" & VARSEP & "LBound", 1 )
		__Set ( Page_DB ( ), PIndex, "Desc" & VARSEP & "UBound", UBound( .Desc, 1 ) )
		
		For DIndex As Long = 1 To UBound ( .Desc, 1 ) Step 1				
			
			Queue_Buffer = Allocate_Desc_Direct ( Page, DIndex, Queue_Buffer )
			
			With .Desc ( DIndex )

				__Set ( Page_DB ( ), PIndex, "Desc" & VARSEP & DIndex & VARSEP & "Text", .Text )
				__Set ( Page_DB ( ), PIndex, "Desc" & VARSEP & DIndex & VARSEP & "Active", .Active )
			
			End With
			
		Next DIndex

	End With

	Return Queue_Buffer
	
End Function


Function Allocate_Entity_Direct ( Page As Story_Page_Type, EIndex As Long = 0, Buffer As String = "" ) As String
	
	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer

	'With Entity
		
		If EIndex < 1 Or EIndex > UBound ( Page .Entity, 1 ) Then
			Return Queue_Buffer
		End If

		Subject_Buffer = Trim ( Prefix ( CRLF, Queue_Buffer ), QUOT )
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
		
		Page .Entity ( EIndex ) .Raw = Subject_Buffer
				
		Select Case StrPos ( EQ, Page .Entity ( EIndex ) .Raw )
		Case 0
			Page .Entity ( EIndex ) .Element = "npc"
			Page .Entity ( EIndex ) .ID = Page .Entity ( EIndex ) .Raw
		Case Is > 0
			Page .Entity ( EIndex ) .Element = LCase ( Prefix ( EQ, Page .Entity ( EIndex ) .Raw ) )
			Page .Entity ( EIndex ) .ID = Suffix ( EQ, Page .Entity ( EIndex ) .Raw )
		End Select
			
		Select Case StrPos ( COLON, Page .Entity ( EIndex ) .ID )
		Case 0
			Page .Entity ( EIndex ) .Count = 1
		Case Is > 0
			Page .Entity ( EIndex ) .Count = ValInt ( Prefix ( COLON, Page .Entity ( EIndex ) .ID ) )
			Page .Entity ( EIndex ) .ID = UCWords ( Suffix ( COLON, Page .Entity ( EIndex ) .ID ) )
		End Select
		
		Select Case StrPos ( SP, Page .Entity ( EIndex ) .ID )
		Case 0
			Page .Entity ( EIndex ) .Mode = "Normal"
			Page .Entity ( EIndex ) .ID = UCWords ( Page .Entity ( EIndex ) .ID )
		Case Is > 0
			Page .Entity ( EIndex ) .Mode = UCWords ( Prefix ( SP, Page .Entity ( EIndex ) .ID ) )
			Page .Entity ( EIndex ) .ID = UCWords ( Suffix ( SP, Page .Entity ( EIndex ) .ID ) )
		End Select
		
		Select Case Page .Entity ( EIndex ) .Mode
		Case "Mad", "Dead", "Normal"
		Case Else
			Page .Entity ( EIndex ) .ID = Page .Entity ( EIndex ) .Mode & SP & Page .Entity ( EIndex ) .ID
			Page .Entity ( EIndex ) .Mode = "Normal"
		End Select
		
		Page .Entity ( EIndex ) .Active = 0

	'End With
	
	Return Queue_Buffer
	
End Function


Function Allocate_Options_Direct ( Page As Story_Page_Type, OIndex As Long = 0, Buffer As String = "" ) As String
	
	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer

	'With Options

		Subject_Buffer = Prefix ( CRLF, Queue_Buffer )
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )

		Page. Options ( OIndex ) .Key = Trim ( Prefix ( COMMA, Subject_Buffer ), QUOT )
		
		Subject_Buffer = Suffix ( COMMA, Subject_Buffer )
		Page. Options ( OIndex ) .Dest = ValInt ( Trim ( Prefix ( COMMA, Subject_Buffer ), QUOT ) )
		
		Subject_Buffer = Suffix ( COMMA, Subject_Buffer )
		Page. Options ( OIndex ) .Req = ValInt ( Trim ( Prefix ( COMMA, Subject_Buffer ), QUOT ) )
		
		Subject_Buffer = Suffix( COMMA, Subject_Buffer )
		Page. Options ( OIndex ) .Caption = Trim ( Subject_Buffer, QUOT )

		Page. Options ( OIndex ) .Active = 0

		'Subject_Buffer = ""
		'Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
	
	'End With
	
	Return Queue_Buffer
	
End Function


Function Allocate_Desc_Direct ( Page As Story_Page_Type, DIndex As Long = 0, Buffer As String = "" ) As String

	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer

	'With Desc
		
		Subject_Buffer = Prefix ( CRLF, Queue_Buffer )
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
			
		Page .Desc ( DIndex ) .Text = Trim ( Subject_Buffer, QUOT )
			
		If Len ( Page .Desc ( DIndex ) .Text ) > 0 Then
			Page .Desc ( DIndex ) .Active = 1
		Else
			Page .Desc ( DIndex ) .Active = 0
		End If
			
		'Subject_Buffer = Prefix ( CRLF, Queue_Buffer )
		'Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
			
	'End With

	Return Queue_Buffer
	
End Function

Function Allocate_Header_Direct ( Page As Story_Page_Type, Buffer As String = "" ) As String
	
	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer
		
	'With Page
			
		Subject_Buffer = Prefix ( CRLF, Queue_Buffer )
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
		
		Dim As Long PIndex = Page .Index
		
		Page .Caption = Trim ( Subject_Buffer, QUOT )
	
		Subject_Buffer = Prefix ( CRLF, Queue_Buffer )
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
		
		Page .A = ValInt ( Prefix ( ",", Subject_Buffer ) )
		Subject_Buffer = Suffix ( ",", Subject_Buffer )
		
		Page .B = ValInt ( Prefix ( ",", Subject_Buffer ) )
		Subject_Buffer = Suffix ( ",", Subject_Buffer )

		Page .Sprite = Trim ( Subject_Buffer, QUOT )
	
	'End With
		
	Return Queue_Buffer
	
End Function
